﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary.SoundArchiveElements
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Runtime.InteropServices;
    using Binarization;

    [StructLayout(LayoutKind.Sequential)]
    [DomElement(Tags = new string[] { "Element" })]
    [DomElementType(Value = (UInt16)ElementType.SoundArchiveFile_SoundInfo)]
    internal sealed class SoundInfo
    {
        private UInt32 fileID = UInt32.MaxValue;
        private BinaryItemID playerID = BinaryItemID.InvalidValue;
        private Byte volume = 0;
        private Byte remoteFilter = 0;
        private SoundParameterArray parameters = new SoundParameterArray();

        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        public UInt32 FileID
        {
            get { return this.fileID; }
            set { this.fileID = value; }
        }

        public BinaryItemID PlayerID
        {
            get { return this.playerID; }
            set { this.playerID = value; }
        }

        public Byte Volume
        {
            get { return this.volume; }
            set { this.volume = value; }
        }

        public Byte RemoteFilter
        {
            get { return this.remoteFilter; }
            set { this.remoteFilter = value; }
        }

        public UInt16 Padding1
        {
            get { return 0; }
        }

        [DomObjectReference(
            OriginTag = "Element", HasType = true, HasOffset = true)]
        public object TypeDependentInfoReference
        {
            get { return this.TypeDependentInfo; }
        }

        public SoundParameterArray Parameters
        {
            get { return this.parameters; }
        }

        public object TypeDependentInfo { get; set; }
    }
}
