﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary.SoundArchiveElements
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Runtime.InteropServices;
    using Binarization;

    [StructLayout(LayoutKind.Sequential)]
    [DomElement(Tags = new string[] { "Element" })]
    internal class InfoSection<TItem>
        where TItem : class
    {
        private ReferenceTable<TItem> table = new ReferenceTable<TItem>();

        protected InfoSection()
        {
            this.table.Items = new List<TItem>();
        }

        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        public ReferenceTable<TItem> Table
        {
            get { return this.table; }
        }

        public IList<TItem> Items
        {
            get { return this.table.Items; }
        }
    }
}
