﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary.SoundArchiveElements
{
    using System.Collections.Generic;
    using System.Runtime.InteropServices;
    using Binarization;

    [StructLayout(LayoutKind.Sequential)]
    [DomElement(Tags = new string[] { "Element" })]
    internal class InfoBlockBody
    {
        private object[] sections;

        public InfoBlockBody()
        {
            this.SoundInfoSection = new SoundInfoSection();
            this.SoundGroupInfoSection = new SoundGroupInfoSection();
            this.BankInfoSection = new BankInfoSection();
            this.WaveArchiveInfoSection = new WaveArchiveInfoSection();
            this.GroupInfoSection = new GroupInfoSection();
            this.PlayerInfoSection = new PlayerInfoSection();
            this.FileInfoSection = new FileInfoSection();
            this.SoundArchivePlayerInfoSection = new SoundArchivePlayerInfo();

            sections = new object[]
            {
                this.SoundInfoSection,
                this.SoundGroupInfoSection,
                this.BankInfoSection,
                this.WaveArchiveInfoSection,
                this.GroupInfoSection,
                this.PlayerInfoSection,
                this.FileInfoSection,
                this.SoundArchivePlayerInfoSection,
            };
        }

        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        [DomObjectReference(
            OriginTag = "Element", HasType = true, HasOffset = true)]
        public IEnumerable<object> Sections
        {
            get { return this.sections; }
        }

        public SoundInfoSection SoundInfoSection { get; private set; }

        public SoundGroupInfoSection SoundGroupInfoSection { get; private set; }

        public BankInfoSection BankInfoSection { get; private set; }

        public WaveArchiveInfoSection WaveArchiveInfoSection { get; private set; }

        public GroupInfoSection GroupInfoSection { get; private set; }

        public PlayerInfoSection PlayerInfoSection { get; private set; }

        public FileInfoSection FileInfoSection { get; private set; }

        public SoundArchivePlayerInfo SoundArchivePlayerInfoSection { get; private set; }
    }
}
