﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary.SoundArchiveXmlElements;

namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary
{
    using NintendoWareBinary.SoundArchiveXmlElements;

    public class SoundArchiveBinaryXmlCommon : ISoundArchiveBinaryXml
    {
        SoundArchiveBinaryXml soundArchiveBinaryXml;

        public SoundArchiveBinaryXmlCommon(SoundArchiveBinaryXml soundArchiveBinaryXml)
        {
            this.soundArchiveBinaryXml = soundArchiveBinaryXml;
        }

        public bool GetGroupXmlTotalSize(string groupXmlName, out ulong totalSize)
        {
            foreach (GroupXml groupXml in this.soundArchiveBinaryXml.Groups)
            {
                if (groupXmlName == groupXml.Name)
                {
                    totalSize = groupXml.TotalSize;
                    return true;
                }
            }

            totalSize = 0;
            return false;
        }
    }
}
