﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary.BankElements
{
    using System.Collections.Generic;
    using System.Runtime.InteropServices;
    using Binarization;

    [StructLayout(LayoutKind.Sequential)]
    [DomElement(Tags = new string[] { "Element" })]
    internal class InfoBlockBody
    {
        private EmbeddingTable<WaveID> waveIDTable = new EmbeddingTable<WaveID>();
        private InstrumentSet instrumentSet = new InstrumentSet();

        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        [DomObjectReference(
            OriginTag = "Element", HasType = true, HasOffset = true)]
        public EmbeddingTable<WaveID> WaveIDTableReference
        {
            get { return this.waveIDTable; }
        }

        public InstrumentSet InstrumentSet
        {
            get { return this.instrumentSet; }
        }

        public EmbeddingTable<WaveID> WaveIDTable
        {
            get { return this.waveIDTable; }
        }
    }
}
