﻿namespace NintendoWare.SoundFoundation.FileFormats.NintendoSdkBinary
{
    using System;
    using System.Collections.Generic;
    using System.Runtime.InteropServices;
    using NintendoWare.SoundFoundation.Binarization;

    [StructLayout(LayoutKind.Sequential)]
    [DomElement(Tags = new string[] { "Element" })]
    internal class BinaryBlockHeader
    {
        private const int SignatureLength = 4;

        private string signature = "    ";

        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        /// <summary>
        /// シグネチャを取得または設定します。
        /// 値は、英数字 4 文字にする必要があります。
        /// </summary>
        public string Signature
        {
            get { return this.signature; }
            set
            {
                if (null == value) { throw new ArgumentNullException("value"); }
                if (SignatureLength != value.Length) { throw new ArgumentOutOfRangeException("value"); }
                this.signature = value;
            }
        }

        /// <summary>
        /// 次のバイナリブロックへのオフセット出力のために、
        /// 次のバイナリブロックへの参照を取得または設定します。
        /// </summary>
        [DomObjectReference(HasOffset = true, OriginTag = "Element")]
        public BinaryBlock NextBlockReferenceForOffsetToNextBlock { get; set; }

        /// <summary>
        /// このバイナリブロックボディのサイズ出力のために、
        /// このバイナリブロックボディへの参照を取得または設定します。
        /// </summary>
        [DomObjectReference(HasSize = true)]
        public object BodyReferenceForBodySize { get; set; }

        /// <summary>
        /// 予約領域の 4 バイト値を取得します。
        /// </summary>
        public UInt32 Reserved
        {
            get { return 0; }
        }
    }
}
