﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NintendoWare.SoundMaker.FileFormats
{
    using NintendoWare.SoundFoundation.FileFormats.Wave;

    public interface IWaveFileInfo
    {
        DateTime LastModifiedTime { get; }
        string FilePath { get; }

        void Open(string filePath);

        /// <summary>
        /// 波形ファイルを開きます。
        /// </summary>
        /// <param name="filePath">ファイルパスを指定します。</param>
        /// <param name="isLoop">
        /// ループの有無を指定します。
        /// null を指定すると波形ファイルのループ情報を利用します。
        /// </param>
        /// <param name="loopStartFrame">
        /// ループ開始フレームを指定します。
        /// null を指定すると波形ファイルのループ情報を利用します。
        /// sampleRate と同時に指定する場合は、サンプルレート変換後のフレームを指定してください。
        /// </param>
        /// <param name="loopEndFrame">
        /// ループ停止フレームを指定します。
        /// null を指定すると波形ファイルのループ情報を利用します。
        /// sampleRate と同時に指定する場合は、サンプルレート変換後のフレームを指定してください。
        /// </param>
        /// <param name="sampleRate">
        /// サンプルレートを指定します。
        /// 波形ファイルのサンプルレートと異なる場合は、ダウンサンプルされます。
        /// null を指定すると波形ファイルのサンプルレートをそのまま利用します。
        /// </param>
        /// <param name="channelCount">
        /// チャンネル数を指定します。
        /// 波形ファイルのチャンネル数と異なる場合は、ダウンミックスされます。（現時点ではモノラル化のみ）
        /// null を指定すると波形ファイルのチャンネル数をそのまま利用します。
        /// </param>
        void Open(string filePath, bool? isLoop, int? loopStartFrame, int? loopEndFrame, int? sampleRate, int? channelCount);

        void Invalidate();
        void Dispose();
    }
}
