﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    using System.Collections.Generic;
    using System.Collections.ObjectModel;
    using Projects;
    using ToolDevelopmentKit;

    /// <summary>
    /// コンポーネントに関連するファイルを表すクラスです。
    /// </summary>
    public class ComponentFile
    {
        private ComponentList components = new ComponentList();
        private ComponentList archives = new ComponentList();
        private IOutput outputTarget = null;

        private string externalFilePath = string.Empty;

        public ComponentFile(IOutput outputTarget)
        {
            Ensure.Argument.NotNull(outputTarget);
            this.outputTarget = outputTarget;
        }

        /// <summary>
        /// 出力対象を取得します。
        /// </summary>
        public IOutput OutputTarget
        {
            get { return this.outputTarget; }
        }

        /// <summary>
        /// 関連するコンポーネントのリストを取得します。
        /// </summary>
        public IList<Component> Components
        {
            get { return this.components; }
        }

        /// <summary>
        /// ファイルを格納するアーカイブのリストを取得します。
        /// </summary>
        public IList<Component> Archives
        {
            get { return this.archives; }
        }

        /// <summary>
        /// 外部ファイルパスを取得または設定します。
        /// </summary>
        public string ExternalFilePath
        {
            get { return this.externalFilePath; }
            set { this.externalFilePath = value; }
        }

        /// <summary>
        /// 外部ファイルかどうかを取得します。
        /// </summary>
        public bool IsExternal
        {
            get
            {
                return (this.externalFilePath.Length > 0);
            }
        }

        private class ComponentList : KeyedCollection<Component, Component>
        {
            protected override Component GetKeyForItem(Component item)
            {
                return item;
            }
        }
    }
}
