﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    using Projects;
    using System;
    using ToolDevelopmentKit;

    /// <summary>
    /// 波形ファイルのファイルIDを作成します。
    /// </summary>
    internal class WaveFileIDFactory<TComponent> : FileIDFactory<TComponent>
        where TComponent : Component
    {
        private readonly Func<TComponent, int?> getSampleRateFunc;
        private readonly Func<TComponent, int?> getChannelCountFunc;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="basePath">相対パスの基点となるパスを指定します。</param>
        /// <param name="getSampleRateFunc">サンプルレートを取得する関数を指定します。</param>
        /// <param name="getChannelCountFunc">チャンネル数を取得する関数を指定します。
        /// （現時点ではチャンネル数というよりモノラル 1 かそうでないか 0 を指定）
        /// </param>
        public WaveFileIDFactory(string basePath, Func<TComponent, int?> getSampleRateFunc, Func<TComponent, int?> getChannelCountFunc)
            : base(basePath)
        {
            Ensure.Argument.NotNull(getSampleRateFunc);
            Ensure.Argument.NotNull(getChannelCountFunc);

            this.getSampleRateFunc = getSampleRateFunc;
            this.getChannelCountFunc = getChannelCountFunc;
        }

        /// <summary>
        /// コンポーネントのファイルIDを作成します。
        /// </summary>
        /// <param name="component">コンポーネントを指定します。</param>
        /// <returns>ファイルIDを返します。</returns>
        protected override FileID CreateInternal(TComponent component)
        {
            Assertion.Argument.NotNull(component);
            return FileID.Create(
                base.CreateInternal(component).Value,
                component.Parameters.GetValue(ProjectParameterNames.WaveEncoding).ToString().ToLower(),
                this.getSampleRateFunc(component),
                this.getChannelCountFunc(component),
                "wave"
                );
        }
    }
}
