﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    using System;
    using Projects;
    using ToolDevelopmentKit;

    /// <summary>
    /// ファイルID（コンポーネント名）を作成します。
    /// </summary>
    internal class FileIDByNameFactory<TComponent> : FileIDFactory<TComponent>
        where TComponent : Component
    {
        /// <summary>
        /// コンポーネントのファイルIDを作成します。
        /// </summary>
        /// <param name="component">コンポーネントを指定します。</param>
        /// <returns>ファイルIDを返します。</returns>
        protected override FileID CreateInternal(TComponent component)
        {
            Assertion.Argument.NotNull(component);
            return new FileID(component.Name);
        }
    }
}
