﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    using Projects;
    using ToolDevelopmentKit;

    internal class DependedFileLinkerSelector : ComponentSetupSelector
    {
        public DependedFileLinkerSelector(SoundProjectService soundProjectService, FileManager fileManager)
        {
            Ensure.Argument.NotNull(fileManager);

            this.AddSetup(typeof(StreamSound), new StreamSoundDependedFileLinker(soundProjectService, fileManager));
            this.AddSetup(typeof(WaveSoundSetBase), new WaveSoundSetDependedFileLinker(soundProjectService, fileManager));
            this.AddSetup(typeof(WaveSound), new WaveDependedFileLinker(fileManager));
            this.AddSetup(typeof(SequenceSound), new SequenceSoundDependedFileLinker(fileManager));
            this.AddSetup(typeof(SoundSetBank), new SoundSetBankDependedFileLinker(soundProjectService, fileManager));
            this.AddSetup(typeof(WaveArchiveBase), new WaveArchiveDependedFileLinker(soundProjectService, fileManager));
            this.AddSetup(typeof(GroupBase), new GroupDependedFileLinker(soundProjectService, fileManager));
            this.AddSetup(typeof(VelocityRegion), new VelocityWaveDependedFileLinker(fileManager));
        }
    }
}
