﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    using Projects;

    internal class ComponentProcessorFactorySelector : ComponentSetupSelector
    {
        public ComponentProcessorFactorySelector()
        {
            this.AddSetup(typeof(StreamSound), new StreamSoundProcessorFactory());
            this.AddSetup(typeof(WaveSoundSetBase), new WaveSoundProcessorFactory());
            this.AddSetup(typeof(WaveSound), new WaveSoundWaveProcessorFactory());
            this.AddSetup(typeof(SequenceSound), new SequenceSoundProcessorFactory());
            this.AddSetup(typeof(WaveArchiveBase), new WaveArchiveProcessorFactory());
            this.AddSetup(typeof(GroupBase), new GroupProcessorFactory());
            this.AddSetup(typeof(VelocityRegion), new VelocityRegionWaveProcessorFactory());
            this.AddSetup(typeof(WaveSoundClipConvertModel), new WaveSoundClipWaveProcessorFactory());
        }
    }
}
