﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    using Projects;
    using ToolDevelopmentKit;

    internal class GroupProcessorLinker : ComponentSetup<SoundArchiveContext, GroupBase>
    {
        /// <summary>
        /// コンポーネントを処理します。
        /// </summary>
        /// <param name="context">コンバートコンテキストを指定します。</param>
        /// <param name="component">コンポーネントを指定します。</param>
        protected sealed override void RunInternal(SoundArchiveContext context, GroupBase component)
        {
            Assertion.Argument.NotNull(context);
            Assertion.Argument.NotNull(component);

            if (component.OutputType != GroupOutputType.UserManagement)
            {
                return;
            }

            IOutput output = component.GetOutputTarget();
            IConversionProcessor processor = context.GetProcessor(output, string.Empty);

            Ensure.Operation.ObjectNotNull(processor);

            foreach (var item in component.GetAllItemTargets(context.Traits.IsWaveSound2BinaryEnabled))
            {
                IOutput itemOutput = item.GetOutputTarget();

                string outputID =
                    context.ContainsProcessor(itemOutput, component.Name) ?
                    component.Name : string.Empty;

                processor.Dependencies.Add(
                    context.GetProcessor(itemOutput, outputID));
            }
        }
    }
}
