﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    using System.Collections.Generic;
    using System.Linq;
    using Projects;
    using ToolDevelopmentKit;

    internal class StreamSoundGarbageOutputCollector : ComponentSetup<SoundArchiveContext, StreamSoundBase>
    {
        private FileManager fileManager;

        public StreamSoundGarbageOutputCollector(FileManager fileManager)
        {
            Ensure.Argument.NotNull(fileManager);
            this.fileManager = fileManager;
        }

        /// <summary>
        /// コンポーネントを処理します。
        /// </summary>
        /// <param name="context">コンバートコンテキストを指定します。</param>
        /// <param name="component">コンポーネントを指定します。</param>
        protected sealed override void RunInternal(SoundArchiveContext context, StreamSoundBase component)
        {
            Assertion.Argument.NotNull(context);
            Assertion.Argument.NotNull(component);

            IOutput outputTarget = this.fileManager.GetOutput(component);
            HashSet<string> usingKeys = new HashSet<string>();

            foreach (StreamSoundTrackBase track in
                context.GetFile(outputTarget).Components.
                SelectMany<Projects.Component, Projects.Component>(streamSound => streamSound.Children).
                OfType<StreamSoundTrackBase>().
                Where(item => item.IsEnabled))
            {
                usingKeys.Add(track.FilePath);
            }

            // 入力 .depend ファイルが不要な依存情報を保持していた場合は、ここで削除します。
            foreach (string key in outputTarget.DependentFilePaths.ToArray())
            {
                // サウンドセットファイルへの依存は削除しない
                if (key.EndsWith(context.Traits.IntermediateOutputTraits.SoundSetFileExtension))
                {
                    continue;
                }

                if (usingKeys.Contains(key))
                {
                    continue;
                }

                this.fileManager.UnregisterDependedFile(outputTarget, key);
            }
        }
    }
}
