﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    using System.Collections.Generic;
    using System.Linq;
    using Projects;
    using ToolDevelopmentKit;

    internal class SoundSetBankGarbageOutputCollector : ComponentSetup<SoundArchiveContext, SoundSetBankBase>
    {
        private FileManager fileManager;

        public SoundSetBankGarbageOutputCollector(FileManager fileManager)
        {
            Ensure.Argument.NotNull(fileManager);
            this.fileManager = fileManager;
        }

        /// <summary>
        /// コンポーネントを処理します。
        /// </summary>
        /// <param name="context">コンバートコンテキストを指定します。</param>
        /// <param name="component">コンポーネントを指定します。</param>
        protected sealed override void RunInternal(SoundArchiveContext context, SoundSetBankBase component)
        {
            Assertion.Argument.NotNull(context);
            Assertion.Argument.NotNull(component);

            // メインサウンドアーカイブのバンクを追加サウンドアーカイブで参照する場合はバンク情報のみを出力するので、スキップする
            if (context.IsExternalSoundArchiveBank(component))
            {
                return;
            }

            IOutput outputTarget = this.fileManager.GetOutput(component);
            HashSet<string> usingKeys = new HashSet<string>();

            foreach (SoundSetBankBase sourceSoundSetBank in
                context.GetFile(outputTarget).Components.OfType<SoundSetBankBase>())
            {
                foreach (KeyValuePair<string, WaveArchiveBase> item in sourceSoundSetBank.GetWaveArchiveDictionary())
                {
                    usingKeys.Add(item.Key);
                }
            }

            usingKeys.Add(SoundSetBankProcessorFactory.OutputID_Include);

            // 入力 .depend ファイルが不要な出力アイテムを保持していた場合は、ここで削除します。
            foreach (string key in outputTarget.ItemDictionary.Keys.ToArray())
            {
                if (usingKeys.Contains(key))
                {
                    continue;
                }

                outputTarget.ItemDictionary[key].Clean();
                outputTarget.ItemDictionary.Remove(key);
            }
        }
    }
}
