﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.ToolDevelopmentKit;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    internal class WaveArchiveFileOptimizer : ComponentSetup<SoundArchiveContext, WaveArchiveBase>
    {
        /// <summary>
        /// コンポーネントを処理します。
        /// </summary>
        /// <param name="context">コンバートコンテキストを指定します。</param>
        /// <param name="component">コンポーネントを指定します。</param>
        protected sealed override void RunInternal(SoundArchiveContext context, WaveArchiveBase component)
        {
            Assertion.Argument.NotNull(context);
            Assertion.Argument.NotNull(component);

            WaveArchiveEx.OutputTargetList outputTargets = component.GetItemOutputTargets();

            foreach (Component item in component.GetItems())
            {
                IOutput outputTarget = item.GetOutputTarget();
                if (outputTarget == null)
                {
                    throw new Exception("internal error : outputTarget not found.");
                }

                ComponentFile waveFile = null;
                if (context.ContainsWaveFile(outputTarget))
                {
                    waveFile = context.GetWaveFile(outputTarget);
                }

                if (waveFile != null)
                {
                    if (!waveFile.Archives.Contains(component))
                    {
                        waveFile.Archives.Add(component);
                    }
                }

                if (outputTargets.Contains(outputTarget)) { continue; }

                outputTargets.Add(outputTarget);
            }
        }
    }
}
