﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.ToolDevelopmentKit;

    /// <summary>
    /// Smfからテキストシーケンスを作成します。
    /// </summary>
    public sealed class SmfProcessor : ConversionProcessor<ConversionContext>, IComponentProcessor
    {
        private HashSet<Component> components = new HashSet<Component>();
        private HashSet<Component> relatedComponents = new HashSet<Component>();
        private IOutputItem outputItem;

        public SmfProcessor(SequenceSoundBase component, IOutputItem outputItem)
        {
            Ensure.Argument.NotNull(component);
            Ensure.Argument.NotNull(outputItem);

            if (component.FileType != SequenceSoundFileType.Smf)
            {
                throw new Exception("internal error : sequence sound file type must be smf.");
            }

            this.components.Add(component);
            this.outputItem = outputItem;
            this.TimeBase = 48;
        }

        /// <summary>
        /// 依存するコンポーネントのコレクションを取得します。
        /// </summary>
        public ICollection<Component> Components
        {
            get { return this.components; }
        }

        /// <summary>
        /// 関連するコンポーネントのコレクションを取得します。
        /// </summary>
        public ICollection<Component> RelatedComponents
        {
            get { return this.relatedComponents; }
        }

        public IOutputItem OutputTargetItem
        {
            get { return this.outputItem; }
        }

        public string ConverterExePath { get; set; }

        public int TimeBase { get; set; }

        private Component TargetComponent
        {
            get { return this.components.First(); }
        }

        protected override bool PreRunInternal(ConversionContext context)
        {
            return this.OutputTargetItem.IsDirty;
        }

        protected override bool RunInternal(ConversionContext context)
        {
            if (this.ConverterExePath == null)
            {
                throw new Exception("internal error : converter exe path not initialized.");
            }

            SmfConverter converter = new SmfConverter(this.ConverterExePath)
            {
                InputPath = (this.TargetComponent as SequenceSoundBase).FilePath,
                OutputPath = this.outputItem.Path,
                TimeBase = this.TimeBase,
                TargetComponents = this.components.Concat(this.relatedComponents).ToArray(),
                LogPrefix = "[SEQ] ",
            };

            return converter.Run(context);
        }
    }
}
