﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    using System.IO;
    using System.Xml;
    using System.Xml.Xsl;
    using ToolDevelopmentKit;

    public class SoundArchiveBinaryMapExporter : ISoundArchiveBinaryMapExporter
    {
        //-----------------------------------------------------------------
        // 出力
        //-----------------------------------------------------------------

        public void Export(Stream soundArchiveBinaryXml, Stream output)
        {
            Ensure.Argument.NotNull(soundArchiveBinaryXml);
            Ensure.Argument.NotNull(output);

            using (TextReader reader = new StringReader(Resources.FileResourceCtrProxy.SoundArchiveBinaryMap))
            {
                XslCompiledTransform xslTransform = new XslCompiledTransform();
                XmlWriterSettings writerSettings = new XmlWriterSettings()
                {
                    Indent = true,
                    OmitXmlDeclaration = true,
                };

                xslTransform.Load(XmlReader.Create(reader));
                xslTransform.Transform(XmlReader.Create(soundArchiveBinaryXml), XmlWriter.Create(output, writerSettings));
            }
        }
    }
}
