﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Codecs
{
    using NintendoWare.ToolDevelopmentKit;

    /// <summary>
    /// Waveストリームにエンコードします。
    /// </summary>
    public abstract class NintendoWareWaveEncoder
    {
        /// <summary>
        /// 波形データをエンコードします。
        /// </summary>
        /// <param name="waveStream">波形ストリームを指定します。</param>
        /// <returns>出力の配列を返します。</returns>
        public CodecOutput[] Run(WaveStream waveStream)
        {
            Ensure.Argument.NotNull(waveStream);
            return this.Run(new WaveStream[] { waveStream });
        }

        /// <summary>
        /// 波形データをエンコードします。
        /// </summary>
        /// <param name="waveStreams">波形ストリームの配列を指定します。</param>
        /// <returns>出力の配列を返します。</returns>
        public abstract CodecOutput[] Run(WaveStream[] waveStreams);
    }
}
