﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Codecs
{
    using System;
    using System.Runtime.InteropServices;

    /// <summary>
    /// WaveCodec が生成する DSPADPCM 情報を格納します。
    /// </summary>
    [StructLayout(LayoutKind.Sequential)]
    public struct WaveCodecDspAdpcmData
    {
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 16)]
        public Int16[] Coef;

        public UInt16 Gain;

        public UInt16 Pred_scale;

        public Int16 Yn1;

        public Int16 Yn2;

        public UInt16 Loop_pred_scale;

        public Int16 Loop_yn1;

        public Int16 Loop_yn2;

        public DspAdpcmData ToAdpcmInformation()
        {
            return new DspAdpcmData()
            {
                Coef = this.Coef,
                Pred_scale = this.Pred_scale,
                Yn1 = this.Yn1,
                Yn2 = this.Yn2,
                Loop_pred_scale = this.Loop_pred_scale,
                Loop_yn1 = this.Loop_yn1,
                Loop_yn2 = this.Loop_yn2,
            };
        }
    }
}
