﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Codecs
{
    using System;
    using System.Runtime.InteropServices;

    /// <summary>
    /// WaveCodec が生成するストリームブロック情報を格納します。
    /// </summary>
    [StructLayout(LayoutKind.Sequential)]
    public struct StreamBlockInformation
    {
        public Int32 BlockSamples;

        public Int32 BlockCount;

        public Int32 BlockByte;

        public Int32 LastBlockSamples;

        public Int32 LastBlockByte;

        public Int32 LastBlockPaddedByte;

        public WaveStreamData ToWaveStreamData()
        {
            return new WaveStreamData()
            {
                BlockByte = this.BlockByte,
                BlockCount = this.BlockCount,
                BlockSamples = this.BlockSamples,
                LastBlockByte = this.LastBlockByte,
                LastBlockPaddedByte = this.LastBlockPaddedByte,
                LastBlockSamples = this.LastBlockSamples,
            };
        }
    }
}
