﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Codecs
{
    /// <summary>
    /// コーデックの出力を格納します。
    /// </summary>
    public class CodecOutput
    {
        /// <summary>
        /// フォーマットを取得または設定します。
        /// </summary>
        public WaveFormat Format { get; set; }

        /// <summary>
        /// フレーム数を取得または設定します。
        /// </summary>
        public int FrameCount { get; set; }

        /// <summary>
        /// 出力のバイト配列を取得または設定します。
        /// </summary>
        public byte[] Data { get; set; }

        /// <summary>
        /// ストリーム情報を取得または設定します。
        /// </summary>
        public WaveStreamData StreamData { get; set; }

        /// <summary>
        /// コーデック依存情報を取得または設定します。
        /// </summary>
        public object CodecData { get; set; }
    }
}
