﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Windows.Forms;

namespace NintendoWare.SoundFoundation.Windows.Forms
{
    public interface IListItemToolTipProvider
    {
        ListItemToolTipInfo GetToolTip(string name, IListItem item);
    }

    public class ListItemToolTipInfo
    {
        public ListItemToolTipInfo(string message)
        {
            this.Message = message;
            this.Type = ListItemToolTipType.Normal;
        }

        public ListItemToolTipInfo(string message, ListItemToolTipType type)
        {
            this.Message = message;
            this.Type = type;
        }

        public string Message { get; set; }

        public ListItemToolTipType Type { get; set; }
    }

    public enum ListItemToolTipType
    {
        Disabled,
        Error,
        Warning,
        Normal,
    }
}
