﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Windows.Forms
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel;
    using System.Data;
    using System.Drawing;
    using System.Linq;
    using System.Text;
    using System.Windows.Forms;

    public partial class HeaderCtrlHideWindow : Form
    {
        private int _selectIndex;
        private int _dragIndex;
        private bool _dragChecked;
        private bool _leftButton;
        private bool _drag;
        private bool _suspend;

        public HeaderCtrlHideWindow()
        {
            _dragIndex = -1;
            _selectIndex = -1;

            InitializeComponent();

            UpButton.Enabled = false;
            DownButton.Enabled = false;
        }

        public CheckedListBox.ObjectCollection Items
        {
            get
            {
                return this.checkedListBox.Items;
            }
        }

        public bool GetItemChecked(int index)
        {
            return this.checkedListBox.GetItemChecked(index);
        }

        private void checkedListBox_ItemCheck(object sender, ItemCheckEventArgs e)
        {
            if (_suspend == true) return;

            if (checkedListBox.CheckedIndices.Count == 1)
            {
                if (e.CurrentValue == CheckState.Checked)
                {
                    e.NewValue = CheckState.Checked;
                }
            }
        }

        private void CheckedListBox_MouseDown(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Left)
            {
                this._selectIndex = checkedListBox.SelectedIndex;
                if (this._selectIndex >= 0)
                {
                    this._leftButton = true;
                }
                UpdateStatus();
            }
        }

        private void CheckedListBox_MouseMove(object sender, MouseEventArgs e)
        {
            if (_leftButton)
            {
                if (_drag == false)
                {
                    _drag = true;
                    _dragIndex = checkedListBox.SelectedIndex;
                    _dragChecked = checkedListBox.GetItemChecked(_dragIndex);
                    Cursor = Cursors.Default;
                }
                else if (e.X >= 0 && e.X <= checkedListBox.ClientSize.Width &&
                          e.Y >= 0 && e.Y <= checkedListBox.ClientSize.Height)
                {
                    Cursor = Cursors.Default;
                    int index = checkedListBox.IndexFromPoint(new Point(e.X, e.Y));
                    if (_dragIndex >= 0 && index >= 0 && _dragIndex != index)
                    {
                        insertItems(_dragIndex, index);
                        _dragIndex = index;
                        UpdateStatus();
                        Update();
                    }
                }
                else
                {
                    Cursor = Cursors.No;
                }
            }
        }

        private void CheckedListBox_MouseUp(object sender, MouseEventArgs e)
        {
            Cursor = Cursors.Default;
            _drag = false;
            _leftButton = false;
            if (_dragIndex >= 0)
            {
                checkedListBox.SetItemChecked(_dragIndex, _dragChecked);
                UpdateStatus();
                _dragIndex = -1;
            }
        }

        private void UpButton_Click(object sender, EventArgs e)
        {
            if (0 < _selectIndex)
            {
                swapItems(_selectIndex - 1, _selectIndex);
                --_selectIndex;
                checkedListBox.SelectedIndex = _selectIndex;
                UpdateStatus();
            }
        }

        private void DownButton_Click(object sender, EventArgs e)
        {
            if (_selectIndex < checkedListBox.Items.Count - 1)
            {
                swapItems(_selectIndex, _selectIndex + 1);
                ++_selectIndex;
                checkedListBox.SelectedIndex = _selectIndex;
                UpdateStatus();
            }
        }

        private void swapItems(int indexA, int indexB)
        {
            var item_a = checkedListBox.Items[indexA];
            var item_b = checkedListBox.Items[indexB];
            bool check_a = checkedListBox.GetItemChecked(indexA);
            bool check_b = checkedListBox.GetItemChecked(indexB);
            checkedListBox.Items[indexA] = item_b;
            checkedListBox.Items[indexB] = item_a;

            _suspend = true;
            checkedListBox.SetItemChecked(indexA, check_b);
            checkedListBox.SetItemChecked(indexB, check_a);
            _suspend = false;
        }

        private void insertItems(int beginIndex, int endIndex)
        {
            if (beginIndex < endIndex)
            {
                for (int i = beginIndex; i < endIndex; i++)
                {
                    swapItems(i, i + 1);
                }
            }
            if (endIndex < beginIndex)
            {
                for (int i = beginIndex; i > endIndex; i--)
                {
                    swapItems(i - 1, i);
                }
            }
        }

        private void UpdateStatus()
        {
            int index = this.checkedListBox.SelectedIndex;
            int maxIndex = this.checkedListBox.Items.Count - 1;

            this.UpButton.Enabled = index <= 0 ? false : true;
            this.DownButton.Enabled = index < 0 || index >= maxIndex ? false : true;
            Invalidate();
        }
    }
}
