﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Collections.Specialized;
using System.Linq;
using System.Text;
using NintendoWare.SoundFoundation.Core;

namespace NintendoWare.SoundFoundation.Windows.Forms
{
    public class ComponentKeyRegionCollection : Collection<IKeyRegion>, IKeyRegionCollection
    {
        public event NotifyCollectionChangedEventHandler CollectionChanged;
        private bool _EventFlag = true;

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        IEnumerator<IKeyRegion> IEnumerable<IKeyRegion>.GetEnumerator()
        {
            return this.GetEnumerator();
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public bool IsReadOnly
        {
            get { return ((IList<ITreeObject>)this).IsReadOnly; }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public new int Count
        {
            get { return base.Count; }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public new IKeyRegion this[int index]
        {
            get { return base[index]; }
            set { base[index] = value; }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public new int IndexOf(IKeyRegion region)
        {
            return base.IndexOf(region);
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public new bool Contains(IKeyRegion region)
        {
            return base.Contains(region);
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public new void CopyTo(IKeyRegion[] array, int index)
        {
            base.CopyTo(array, index);
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public void SuspendKeyRegionCollectionEvent()
        {
            _EventFlag = false;
        }

        public void ResumeKeyRegionCollectionEvent()
        {
            _EventFlag = true;
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public ComponentKeyRegion PrevItem(ComponentKeyRegion region)
        {
            ComponentKeyRegion prevRegion = null;

            int index = IndexOf(region) - 1;
            if (0 <= index && index < Count)
            {
                prevRegion = (ComponentKeyRegion)this[index];
            }

            return prevRegion;
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public ComponentKeyRegion NextItem(ComponentKeyRegion region)
        {
            ComponentKeyRegion nextRegion = null;

            int index = IndexOf(region) + 1;
            if (0 <= index && index < Count)
            {
                nextRegion = (ComponentKeyRegion)this[index];
            }

            return nextRegion;
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        protected override void ClearItems()
        {
            base.ClearItems();
            OnCollectionChanged(CreateEventArgsReset());
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        protected override void InsertItem(int index, IKeyRegion region)
        {
            base.InsertItem(index, region);
            OnCollectionChanged(CreateEventArgsAdd(region, IndexOf(region)));
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        protected override void RemoveItem(int index)
        {
            IKeyRegion region = this[index];
            base.RemoveItem(index);
            OnCollectionChanged(CreateEventArgsRemove(region, index));
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        protected NotifyCollectionChangedEventArgs CreateEventArgsReset()
        {
            return new NotifyCollectionChangedEventArgs
                (NotifyCollectionChangedAction.Reset);
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        protected NotifyCollectionChangedEventArgs CreateEventArgsAdd(IKeyRegion region, int index)
        {
            return new NotifyCollectionChangedEventArgs
                (NotifyCollectionChangedAction.Add, region, index);
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        protected NotifyCollectionChangedEventArgs CreateEventArgsRemove(IKeyRegion region, int index)
        {
            return new NotifyCollectionChangedEventArgs
                (NotifyCollectionChangedAction.Remove, region, index);
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        protected void OnCollectionChanged(NotifyCollectionChangedEventArgs e)
        {
            if (_EventFlag == true)
            {
                if (CollectionChanged != null)
                {
                    CollectionChanged(this, e);
                }
            }
        }
    }
}
