﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Drawing;

using NintendoWare.SoundFoundation.Commands;

namespace NintendoWare.SoundFoundation.Windows.CommandBars
{
    /// <summary>
    /// コマンドバーメニューアイテムの情報を管理します。
    /// </summary>
    public class CommandBarMenuItem : CommandBarExecutableItem
    {
        /// <summary>
        /// コンストラクタ。
        /// </summary>
        /// <param name="name">アイテムURI。</param>
        /// <param name="command">関連付けるコマンド。</param>
        public CommandBarMenuItem(string uri, Command command)
            : base(uri, command)
        {
        }

        /// <summary>
        /// コンストラクタ。
        /// 派生クラスには、Command = null を許可する。
        /// </summary>
        protected CommandBarMenuItem(string uri) : base(uri) { }
    }
}
