﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;

using NintendoWare.SoundFoundation.Commands;

namespace NintendoWare.SoundFoundation.Windows.CommandBars
{
    /// <summary>
    /// コマンドバーボタンの情報を管理します。
    /// </summary>
    public class CommandBarButton : CommandBarExecutableItem
    {
        private CommandBarButtonStyle _style = CommandBarButtonStyle.ImageOnly;  // スタイル

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        /// <param name="uri">アイテムURI。</param>
        /// <param name="command">関連付けるコマンド。</param>
        public CommandBarButton(string uri, Command command)
            : base(uri, command)
        {
        }

        /// <summary>
        /// コンストラクタ。
        /// 派生クラスには、Command = null を許可する。
        /// </summary>
        protected CommandBarButton(string uri) : base(uri) { }

        /// <summary>
        /// テキストとイメージの表示スタイルを取得または設定します。
        /// </summary>
        public CommandBarButtonStyle Style
        {
            get { return _style; }
            set { _style = value; }
        }
    }
}
