﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;

namespace NintendoWare.SoundFoundation.Windows.CommandBars
{
    /// <summary>
    /// コマンドバーの情報を管理します。
    /// </summary>
    public class CommandBar
    {
        private string _name = string.Empty;     // 名前

        // グループコレクション
        private CommandBarItemGroupCollection _groups = new CommandBarItemGroupCollection();

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        /// <param name="name">グループの名前。</param>
        public CommandBar(string name)
        {
            if (null == name) { throw new ArgumentNullException("name"); }
            _name = name;
        }

        /// <summary>
        /// コマンドバーの名前を取得します。
        /// </summary>
        public string Name
        {
            get { return _name; }
        }

        /// <summary>
        /// コマンドバーアイテムグループのコレクションを取得します。
        /// </summary>
        public CommandBarItemGroupCollection Groups
        {
            get { return _groups; }
        }

        /// <summary>
        /// 指定 URI を持つ最初のアイテムを検索します。
        /// </summary>
        /// <param name="uri">アイテムの URI。</param>
        /// <returns>該当するアイテム。</returns>
        public CommandBarItem FindFirstItem(string uri)
        {
            return (from CommandBarItemGroup itemGroup in _groups
                    from CommandBarItem item in itemGroup.FindItems(uri)
                    select item).FirstOrDefault();
        }
    }
}
