
var gTrElems;
var gColId = new Array();
var gColIndexTmp;
var gReverse = new Array();

//==================================================================
// type - "number" or "string"
function SortTable( type, obj )
{
    var cellArray = new Array();
    var rowArray = new Array();
    var trClassArray = new Array();
    var tdClassArray = new Array();
    var row;
    var col;

    if ( !document.getElementById ) { return; }

    var tableElem = obj.parentNode.parentNode.parentNode;
    var thElems = obj.parentNode.getElementsByTagName("th");

    for ( col = 0; col < thElems.length; col++ )
    {
        if ( thElems[col] == obj ) gColIndexTmp = col;
    }

    // init
    if ( typeof(gColId[tableElem]) == "undefined" ) {
        gReverse[tableElem] = 0;
        gColId[tableElem] = thElems[0];
    }

    var reverseFlag = 0;
    if ( obj == gColId[tableElem] ) {
        gReverse[tableElem] = - ( gReverse[tableElem] - 1 );
        if ( ! gReverse[tableElem] ) { reverseFlag = 1; }
    }
    else { gReverse[tableElem] = 0; }

    gTrElems = tableElem.getElementsByTagName("tbody")[0].getElementsByTagName("tr");

    //  read table
    if ( reverseFlag ) {
        for ( row = 0; row < gTrElems.length; row++ ) { rowArray[row] = gTrElems.length-row-1; }
    }
    else {
        for ( row = 0; row < gTrElems.length; row++ ) { rowArray[row] = row; }
    }
    for ( row = 0; row < gTrElems.length; row++ )
    {
        var tdElems = gTrElems[row].getElementsByTagName("td");
        trClassArray[row] = gTrElems[row].className;
        cellArray[row]  = new Array();
        tdClassArray[row] = new Array();
        for ( col = 0; col < tdElems.length; col++ )
        {
            cellArray[row][col]  = tdElems[col].innerHTML;
            tdClassArray[row][col] = tdElems[col].className;
        }
    }

    //  sort
    if ( type == "number" ) { rowArray.sort(CompareByNumber); }
    else if ( type == "string" ) { rowArray.sort(CompareByString); }

    if ( gReverse[tableElem] ) { rowArray.reverse(); }

    //  write table
    for ( row = 0; row < gTrElems.length; row++ )
    {
        gTrElems[row].className = trClassArray[rowArray[row]];

        var tdElems = gTrElems[row].getElementsByTagName("td");
        for (col = 0; col < tdElems.length; col++)
        {
            tdElems[col].innerHTML = cellArray[rowArray[row]][col];
            tdElems[col].className = tdClassArray[rowArray[row]][col];
        }
    }

    gColId[tableElem] = obj;

    //  table header
    for ( col = 0; col < thElems.length; col++ ) { thElems[col].className = ""; }
    obj.className = "SortKey";
}

//==================================================================
function CompareByNumber(a, b)
{
    var sA = gTrElems[a].getElementsByTagName("td")[gColIndexTmp].innerHTML;
    var sB = gTrElems[b].getElementsByTagName("td")[gColIndexTmp].innerHTML;

    sA = Number( sA );
    sB = Number( sB );

    if ( ( isNaN( sA ) && isNaN( sB ) ) || sA == sB ) { return 0; }

    if ( isNaN( sA ) ) { return 1; }
    if ( isNaN( sB ) ) { return -1; }

    if ( sA > sB ) { return 1; }
    return -1;
}

//==================================================================
function CompareByString(a, b)
{
    var sA = gTrElems[a].getElementsByTagName("td")[gColIndexTmp].innerHTML;
    var sB = gTrElems[b].getElementsByTagName("td")[gColIndexTmp].innerHTML;

    if ( sA == sB ) { return 0; }

    if ( sA == "&nbsp;" ) { return 1; }
    if ( sB == "&nbsp;" ) { return -1; }

    if ( sA > sB ) { return 1; }
    return -1;
}

//==================================================================
function ResetAllTableOpenCloseButton()
{
    var inputElems = document.getElementsByTagName("input");
    for ( index = 0; index < inputElems.length; index++ )
    {
        if ( inputElems[index].className == "tableopenclose" )
        {
            inputElems[index].setAttribute( "title", "close" );
            inputElems[index].value = "-";
        }
    }

}

//==================================================================
function ShowAllSoundSet()
{
    var soundsetListElem = document.getElementById( "soundsetlist" );
    var soundsetElems = soundsetListElem.getElementsByTagName("div");

    for ( soundsetIndex = 0; soundsetIndex < soundsetElems.length; soundsetIndex++ )
    {
        soundsetElems[soundsetIndex].style.display = "block";
    }

    ResetAllTableOpenCloseButton();
}

//==================================================================
function ShowSoundSet( soundsetId )
{
    var soundsetListElem = document.getElementById( "soundsetlist" );
    var soundsetElems = soundsetListElem.getElementsByTagName("div");

    for ( soundsetIndex = 0; soundsetIndex < soundsetElems.length; soundsetIndex++ )
    {
        soundsetElems[soundsetIndex].style.display = "none";
    }

    var targetElem = document.getElementById( soundsetId );
    targetElem.style.display = "block";

    var datalistElems = targetElem.getElementsByTagName("div");
    for ( index = 0; index < datalistElems.length; index++ )
    {
        datalistElems[index].style.display = "block";
    }

    ResetAllTableOpenCloseButton();
}

//==================================================================
function SwitchDisplay( taragetId, obj )
{
    var target = document.getElementById( taragetId );
    if ( target.style.display == "none" )
    {
        target.style.display = "block";
        obj.setAttribute( "title", "close" );
        obj.value = "-";
    }
    else
    {
        target.style.display = "none";
        obj.setAttribute( "title", "open" );
        obj.value = "+";
    }
}
