﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using NintendoWare.SoundFoundation.Core;

namespace NintendoWare.SoundFoundation.Projects
{
    ///-----------------------------------------------------------------------------
    /// <summary>
    ///
    /// </summary>
    public class ComponentManagerEventArgs : RoutingEventArgs
    {
        private ComponentManager _componentManager = null;

        ///--------------------------------
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public ComponentManagerEventArgs(RoutingEvent routingEvent, ComponentManager componentManager)
            : base(routingEvent)
        {
            _componentManager = componentManager;
        }

        ///
        public ComponentManager ComponentManager
        {
            get { return _componentManager; }
        }
    }

    /// <summary>
    ///
    /// </summary>
    public class ComponentManagerRenamedComponentEventArgs : ComponentManagerEventArgs
    {
        private string oldName = String.Empty;
        private string newName = String.Empty;

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public ComponentManagerRenamedComponentEventArgs(RoutingEvent routingEvent, ComponentManager componentManager, string oldName, string newName)
            : base(routingEvent, componentManager)
        {
            this.oldName = oldName;
            this.newName = newName;
        }

        ///
        public string OldName
        {
            get
            {
                return this.oldName;
            }
        }

        ///
        public string NewName
        {
            get
            {
                return this.newName;
            }
        }
    }
}
