﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Projects
{
    using System.ComponentModel;
    using NintendoWare.SoundFoundation.Core.Parameters;
    using NintendoWare.ToolDevelopmentKit;

    public class Sound3D : INotifyPropertyChanged
    {
        public const string PropertyNameDecayCurve3D = "DecayCurve3D";
        public const string PropertyNameDecayRatio3D = "DecayRatio3D";
        public const string PropertyNameDopplerFactor3D = "DopplerFactor3D";
        public const string PropertyNameEnable3DVolume = "Enable3DVolume";
        public const string PropertyNameEnable3DPan = "Enable3DPan";
        public const string PropertyNameEnable3DSurroundPan = "Enable3DSurroundPan";
        public const string PropertyNameEnable3DPriority = "Enable3DPriority";
        public const string PropertyNameEnable3DFilter = "Enable3DFilter";

        private DecayCurve3D decayCurve3D = DecayCurve3D.Log;
        private float decayRatio3D = 0.5f;
        private int dopplerFactor3D = 0;
        private bool enable3DVolume = true;
        private bool enable3DPan = true;
        private bool enable3DSurroundPan = true;
        private bool enable3DPriority = true;
        private bool enable3DFilter = false;

        /// <summary>
        /// プロパティ値が変更されたときに発生します。
        /// </summary>
        public event PropertyChangedEventHandler PropertyChanged;

        public DecayCurve3D DecayCurve3D
        {
            get { return this.decayCurve3D; }
            set
            {
                if (this.decayCurve3D == value)
                {
                    return;
                }

                this.decayCurve3D = value;
                this.OnNotifyPropertyChanged(new PropertyChangedEventArgs(PropertyNameDecayCurve3D));
            }
        }

        [ValueRange(0.0f, 1.0f)]
        public float DecayRatio3D
        {
            get { return this.decayRatio3D; }
            set
            {
                if (this.decayRatio3D == value)
                {
                    return;
                }

                this.decayRatio3D = value;
                this.OnNotifyPropertyChanged(new PropertyChangedEventArgs(PropertyNameDecayRatio3D));
            }
        }

        [ValueRange(0, 255)]
        public int DopplerFactor3D
        {
            get { return this.dopplerFactor3D; }
            set
            {
                if (this.dopplerFactor3D == value)
                {
                    return;
                }

                this.dopplerFactor3D = value;
                this.OnNotifyPropertyChanged(new PropertyChangedEventArgs(PropertyNameDopplerFactor3D));
            }
        }

        public bool Enable3DVolume
        {
            get { return this.enable3DVolume; }
            set
            {
                if (this.enable3DVolume == value)
                {
                    return;
                }

                this.enable3DVolume = value;
                this.OnNotifyPropertyChanged(new PropertyChangedEventArgs(PropertyNameEnable3DVolume));
            }
        }

        public bool Enable3DPan
        {
            get { return this.enable3DPan; }
            set
            {
                if (this.enable3DPan == value)
                {
                    return;
                }

                this.enable3DPan = value;
                this.OnNotifyPropertyChanged(new PropertyChangedEventArgs(PropertyNameEnable3DPan));
            }
        }

        public bool Enable3DSurroundPan
        {
            get { return this.enable3DSurroundPan; }
            set
            {
                if (this.enable3DSurroundPan == value)
                {
                    return;
                }

                this.enable3DSurroundPan = value;
                this.OnNotifyPropertyChanged(new PropertyChangedEventArgs(PropertyNameEnable3DSurroundPan));
            }
        }

        public bool Enable3DPriority
        {
            get { return this.enable3DPriority; }
            set
            {
                if (this.enable3DPriority == value)
                {
                    return;
                }

                this.enable3DPriority = value;
                this.OnNotifyPropertyChanged(new PropertyChangedEventArgs(PropertyNameEnable3DPriority));
            }
        }

        public bool Enable3DFilter
        {
            get { return this.enable3DFilter; }
            set
            {
                if (this.enable3DFilter == value)
                {
                    return;
                }

                this.enable3DFilter = value;
                this.OnNotifyPropertyChanged(new PropertyChangedEventArgs(PropertyNameEnable3DFilter));
            }
        }

        /// <summary>
        /// プロパティ値が変更されたときに発生します。
        /// </summary>
        /// <param name="e">イベントパラメータを指定します。</param>
        private void OnNotifyPropertyChanged(PropertyChangedEventArgs e)
        {
            Assertion.Argument.NotNull(e);

            if (this.PropertyChanged != null)
            {
                this.PropertyChanged(this, e);
            }
        }
    }
}
