﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Projects
{
    using System.ComponentModel;
    using Core.Parameters;
    using ToolDevelopmentKit;

    public class Envelope : INotifyPropertyChanged
    {
        public const string PropertyNameAttack = "Attack";
        public const string PropertyNameDecay = "Decay";
        public const string PropertyNameSustain = "Sustain";
        public const string PropertyNameHold = "Hold";
        public const string PropertyNameRelease = "Release";

        private int attack = 127;
        private int decay = 127;
        private int sustain = 127;
        private int hold = 0;
        private int release = 127;

        /// <summary>
        /// プロパティ値が変更されたときに発生します。
        /// </summary>
        public event PropertyChangedEventHandler PropertyChanged;

        [ValueRange(0, 127)]
        public int Attack
        {
            get { return this.attack; }
            set
            {
                if (this.attack == value)
                {
                    return;
                }

                this.attack = value;
                this.OnNotifyPropertyChanged(new PropertyChangedEventArgs(PropertyNameAttack));
            }
        }

        [ValueRange(0, 127)]
        public int Decay
        {
            get { return this.decay; }
            set
            {
                if (this.decay == value)
                {
                    return;
                }

                this.decay = value;
                this.OnNotifyPropertyChanged(new PropertyChangedEventArgs(PropertyNameDecay));
            }
        }

        [ValueRange(0, 127)]
        public int Sustain
        {
            get { return this.sustain; }
            set
            {
                if (this.sustain == value)
                {
                    return;
                }

                this.sustain = value;
                this.OnNotifyPropertyChanged(new PropertyChangedEventArgs(PropertyNameSustain));
            }
        }

        [ValueRange(0, 127)]
        public int Hold
        {
            get { return this.hold; }
            set
            {
                if (this.hold == value)
                {
                    return;
                }

                this.hold = value;
                this.OnNotifyPropertyChanged(new PropertyChangedEventArgs(PropertyNameHold));
            }
        }

        [ValueRange(0, 127)]
        public int Release
        {
            get { return this.release; }
            set
            {
                if (this.release == value)
                {
                    return;
                }

                this.release = value;
                this.OnNotifyPropertyChanged(new PropertyChangedEventArgs(PropertyNameRelease));
            }
        }

        /// <summary>
        /// プロパティ値が変更されたときに発生します。
        /// </summary>
        /// <param name="e">イベントパラメータを指定します。</param>
        private void OnNotifyPropertyChanged(PropertyChangedEventArgs e)
        {
            Assertion.Argument.NotNull(e);

            if (this.PropertyChanged != null)
            {
                this.PropertyChanged(this, e);
            }
        }
    }
}
