﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NintendoWare.SoundFoundation.Projects
{
    public class UserParameterStructureSettings
    {
        private const int MaxSettingCount = 4;

        private List<UserParameterStructureSetting> settings = new List<UserParameterStructureSetting>();

        public UserParameterStructureSettings()
        {
            for (int count = 0; count < MaxSettingCount; count++)
            {
                this.settings.Add(new UserParameterStructureSetting());
            }

            if (MaxSettingCount > 0)
            {
                this.settings[0].Enabled = true;
            }
        }

        public List<UserParameterStructureSetting> Settings
        {
            get
            {
                return this.settings;
            }
        }
    }
}
