﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Projects
{
    using System;
    using System.Diagnostics;
    using NintendoWare.SoundFoundation.Core;
    using NintendoWare.SoundFoundation.Core.Parameters;

    public static class SinglePlayTypeEx
    {
        public static string ToText(this SinglePlayType value)
        {
            switch (value)
            {
                case SinglePlayType.None:
                    return "None";

                case SinglePlayType.PrioritizeNewest:
                    return "PrioritizeNewest";

                case SinglePlayType.PrioritizeNewestEffectiveDuration:
                    return "PrioritizeNewestEffectiveDuration";

                case SinglePlayType.PrioritizeOldest:
                    return "PrioritizeOldest";

                case SinglePlayType.PrioritizeOldestEffectiveDuration:
                    return "PrioritizeOldestEffectiveDuration";
            }

            Debug.Assert(false, "An unexpected value");
            return String.Empty;
        }

        public static SinglePlayType Parse(string text)
        {
            if (null == text) { throw new ArgumentNullException("text"); }

            switch (text)
            {
                case "None":
                    return SinglePlayType.None;

                case "PrioritizeNewest":
                    return SinglePlayType.PrioritizeNewest;

                case "PrioritizeNewestEffectiveDuration":
                    return SinglePlayType.PrioritizeNewestEffectiveDuration;

                case "PrioritizeOldest":
                    return SinglePlayType.PrioritizeOldest;

                case "PrioritizeOldestEffectiveDuration":
                    return SinglePlayType.PrioritizeOldestEffectiveDuration;
            }

            throw new ArgumentException("invalid text.");
        }
    }
}
