﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Projects
{
    using System;
    using System.Diagnostics;
    using NintendoWare.SoundFoundation.Core;
    using NintendoWare.SoundFoundation.Core.Parameters;

    public static class InstrumentEnvelopeModeEx
    {
        public static string ToText(this InstrumentEnvelopeMode value)
        {
            switch (value)
            {
                case InstrumentEnvelopeMode.Instrument:
                    return "Instrument";

                case InstrumentEnvelopeMode.KeyRegion:
                    return "KeyRegion";

                case InstrumentEnvelopeMode.VelocityRegion:
                    return "VelocityRegion";

                case InstrumentEnvelopeMode.Lower:
                    return "Lower";

                case InstrumentEnvelopeMode.Invalid:
                    return "Invalid";

            }

            Debug.Assert(false, "An unexpected value");
            return String.Empty;
        }

        public static InstrumentEnvelopeMode Parse(string text)
        {
            if (null == text) { throw new ArgumentNullException("text"); }

            switch (text)
            {
                case "Instrument":
                    return InstrumentEnvelopeMode.Instrument;

                case "KeyRegion":
                    return InstrumentEnvelopeMode.KeyRegion;

                case "VelocityRegion":
                    return InstrumentEnvelopeMode.VelocityRegion;

                case "Lower":
                    return InstrumentEnvelopeMode.Lower;

                case "Invalid":
                    return InstrumentEnvelopeMode.Invalid;
            }

            throw new ArgumentException("invalid text.");
        }
    }
}
