﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Projects
{
    using System;
    using System.Collections.Generic;
    using System.Linq;

    public class SoundProjectDocument : SoundDocument
    {
        private string documentTypeName = string.Empty;

        private ComponentDictionaryImpl components = null;
        private SoundProject project = null;

        private bool _settingsDirty = false;

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public SoundProjectDocument(string documentTypeName)
        {
            if (null == documentTypeName) { throw new ArgumentNullException("documentTypeName"); }
            if (0 == documentTypeName.Length) { throw new ArgumentException("documentTypeName.Length must not be 0."); }

            this.documentTypeName = documentTypeName;
            this.components = new ComponentDictionaryImpl();
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public SoundProject Project
        {
            get { return this.project; }
            set
            {
                this.project = value;
                this.components.Add(this.project.Name, this.project);
            }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public override string TypeName
        {
            get { return this.documentTypeName; }
        }

        /// <summary>
        /// ドキュメントの最上位コンポーネントの一覧を取得します。
        /// </summary>
        public override Component[] TopComponents
        {
            get { return new Component[] { Project }; }
        }

        /// <summary>
        /// Dirty 状態がリセットされると発生します。
        /// </summary>
        protected override void OnResetDirty()
        {
            base.OnResetDirty();
            _settingsDirty = false;
        }

        /// <summary>
        /// 他の要因でドキュメントが編集されているかどうかを調べます。
        /// </summary>
        protected override bool IsDirtyOtherFactor
        {
            get { return _settingsDirty; }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public override object Clone()
        {
            //未実装
            return null;
        }

        /// <summary>
        /// プロジェクト設定の Dirty 状態を true にします。
        /// </summary>
        public void SetDirty()
        {
            if (_settingsDirty == true) { return; }

            bool dirty = IsDirty;

            _settingsDirty = true;

            if (dirty != IsDirty)
            {
                OnDirtyChanged(EventArgs.Empty);
            }
        }
    }
}

