﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Projects
{
    public class PlayerBase : SoundSetItem
    {
        ///--------------------------------
        /// <summary>
        /// サウンドリミット
        /// </summary>
        public int SoundLimit
        {
            get { return GetIntValue(ProjectParameterNames.Player.SoundLimit); }
            set { SetIntValue(ProjectParameterNames.Player.SoundLimit, value); }
        }

        ///--------------------------------
        /// <summary>
        /// ヒープサイズ
        /// </summary>
        public int HeapSize
        {
            get { return GetIntValue(ProjectParameterNames.Player.HeapSize); }
            set { SetIntValue(ProjectParameterNames.Player.HeapSize, value); }
        }

        ///--------------------------------
        /// <summary>
        /// パラメータを初期化します。
        /// </summary>
        protected override void InitializeParameters()
        {
            base.InitializeParameters();

            SetInstanceIntValue(ProjectParameterNames.Player.SoundLimit, 1, 0, 255);
            SetInstanceIntValue(ProjectParameterNames.Player.HeapSize, 0, 0, int.MaxValue);
        }
    }
}
