﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Projects
{
    using ToolDevelopmentKit;

    /// <summary>
    /// アイテムの命名設定
    /// </summary>
    public class ItemNamingSettings
    {
        private SoundProject project;

        private bool hasPrefix;
        private CaseChangeType caseChange;
        private InvalidCharChangeType invalidCharChange;
        private bool enabledNameDelimiter;
        private string nameDelimiter;

        /// <summary>
        ///
        /// </summary>
        public ItemNamingSettings(SoundProject project)
        {
            Ensure.Argument.NotNull(project);
            this.project = project;
        }

        /// <summary>
        ///
        /// </summary>
        public ItemNamingSettings(bool hasPrefix, CaseChangeType caseChange, InvalidCharChangeType invalidCharChange, bool enabledNameDelimiter, string nameDelimiter)
        {
            this.hasPrefix = hasPrefix;
            this.caseChange = caseChange;
            this.invalidCharChange = invalidCharChange;
            this.enabledNameDelimiter = enabledNameDelimiter;
            this.nameDelimiter = nameDelimiter;
        }

        /// <summary>
        /// プレフィックスを持つかどうかを取得または設定します。
        /// </summary>
        public bool HasPrefix
        {
            get
            {
                if (this.project != null)
                {
                    return this.project.ItemNamingHasPrefix;
                }

                return this.hasPrefix;
            }
        }

        /// <summary>
        /// 大文字小文字の扱い設定を取得または設定します。
        /// </summary>
        public CaseChangeType CaseChange
        {
            get
            {
                if (this.project != null)
                {
                    return this.project.ItemNamingCaseChange;
                }

                return this.caseChange;
            }
        }

        /// <summary>
        /// 禁則文字の扱い設定を取得または設定します。
        /// </summary>
        public InvalidCharChangeType InvalidCharChange
        {
            get
            {
                if (this.project != null)
                {
                    return this.project.ItemNamingInvalidCharChange;
                }

                return this.invalidCharChange;
            }
        }

        /// <summary>
        ///
        /// </summary>
        public bool EnabledNameDelimiter
        {
            get
            {
                if (this.project != null)
                {
                    return this.project.EnabledNameDelimiter;
                }

                return this.enabledNameDelimiter;
            }
        }

        /// <summary>
        ///
        /// </summary>
        public string NameDelimiter
        {
            get
            {
                if (this.project != null)
                {
                    return this.project.NameDelimiter;
                }

                return this.nameDelimiter;
            }
        }
    }
}
