﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Projects
{
    using NintendoWare.SoundFoundation.Core.Parameters;

    public class GroupBase : SoundSetItem
    {
        public const string ParameterNameOfDataSize = "DataSize";

        /// <summary>
        /// ファイル参照タイプを取得または設定します。
        /// </summary>
        public GroupOutputType OutputType
        {
            get { return GetValue<GroupOutputType>(ProjectParameterNames.Group.OutputType); }
            set { SetValue<GroupOutputType>(ProjectParameterNames.Group.OutputType, value); }
        }

        /// <summary>
        /// データサイズ
        /// </summary>
        public int DataSize
        {
            get { return GetIntValue(ParameterNameOfDataSize); }
            set { SetIntValue(ParameterNameOfDataSize, value); }
        }

        ///--------------------------------
        /// <summary>
        /// パラメータを初期化します。
        /// </summary>
        protected override void InitializeParameters()
        {
            base.InitializeParameters();

            this.Parameters.AddValue(
               ProjectParameterNames.Group.OutputType,
               new GroupOutputTypeParameterValue());

            SetInstanceIntValue(ParameterNameOfDataSize, -1);

            // グループバイナリ依存パラメータ
            this.SetParameterAttributes(ProjectParameterNames.Group.OutputType, ParameterAttributes.ComputeHash);
        }
    }
}
