﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Projects
{
    using System;
    using Core;

    /// <summary>
    /// バンクのコンポーネントを生成します。
    /// </summary>
    public class BankComponentFactory : ObjectAggregateFactory<Type, Component>
    {
        public BankComponentFactory()
        {
            this.Factories.Add(typeof(Bank), new ComponentFactory<Bank>());
            this.Factories.Add(typeof(Instrument), new ComponentFactory<Instrument>());
            this.Factories.Add(typeof(KeyRegion), new ComponentFactory<KeyRegion>());
            this.Factories.Add(typeof(VelocityRegion), new ComponentFactory<VelocityRegion>());
        }
    }
}
