﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareIntermediate
{
    using System;
    using System.Xml.Serialization;

    [Serializable]
    [XmlRoot(
        XmlParameterNames.InstrumentNoteOffMode,
        Namespace = XmlNamespaces.Base,
        IsNullable = false)]
    public class XmlInstrumentNoteOffModeParam : XmlSimpleParameter<XmlInstrumentNoteOffMode>
    {
        public XmlInstrumentNoteOffModeParam()
            : base(XmlInstrumentNoteOffMode.Release)
        {
        }

        /// <summary>
        /// Name属性は定義しません。
        /// </summary>
        [XmlIgnore]
        public override bool NameSpecified
        {
            get { return false; }
        }

        /// <summary>
        /// 名前を検証し有効化します。
        /// </summary>
        /// <param name="name">名前を指定します。</param>
        /// <returns>有効化された名前を返します。</returns>
        protected override string ValidateName(string name)
        {
            return XmlParameterNames.InstrumentNoteOffMode;
        }

        protected override string ValueToString(XmlInstrumentNoteOffMode value)
        {
            return value.ToText();
        }

        protected override XmlInstrumentNoteOffMode Parse(string text)
        {
            return XmlInstrumentNoteOffModeEx.Parse(text);
        }
    }
}
