﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareIntermediate
{
    using System;
    using Core;
    using Projects;
    using ToolDevelopmentKit;
    using ToolDevelopmentKit.Conversion;

    public class SoundSetXml2ModelTranslator : Xml2ModelTranslator
    {
        public SoundSetXml2ModelTranslator(IObjectFactory<Type, Component> componentFactory,
                                           SoundSetItemParamTranslator paramTranslator)
            : base(componentFactory, paramTranslator)
        {
        }

        public SoundSetXml2ModelTranslator(IObjectFactory<Type, Component> componentFactory)
            : base(componentFactory, new SoundSetItemParamTranslator())
        {
            this.AddConverter<XmlSoundSet, SoundSet>();
            this.AddConverter<XmlSoundSetItemFolder, SoundSetItemPack>(XmlSoundSetItemFolderToSoundSetItemPack);
            this.AddConverter<XmlStreamSound, StreamSoundBase>();
            this.AddConverter<XmlStreamSoundTrack, StreamSoundTrackBase>();
            this.AddConverter<XmlWaveSoundSet, WaveSoundSetBase>();
            this.AddConverter<XmlWaveSound, WaveSoundBase>();
            this.AddConverter<XmlSequenceSoundSet, SequenceSoundSetBase>();
            this.AddConverter<XmlSequenceSound, SequenceSoundBase>();
            this.AddConverter<XmlSoundSetBank, SoundSetBankBase>();
            this.AddConverter<XmlPlayer, PlayerBase>();
            this.AddConverter<XmlWaveArchive, WaveArchiveBase>();
            this.AddConverter<XmlGroup, GroupBase>();
            this.AddConverter<XmlGroupItem, GroupItemBase>();
        }

        public SoundSet Run(XmlSoundSet xmlSoundSet)
        {
            return this.Run<SoundSet>(xmlSoundSet) as SoundSet;
        }

        /// <summary>
        /// XmlSoundSetItemFolder から SoundSetItemPack に変換します。
        /// </summary>
        /// <param name="src">変換元のオブジェクトを指定します。</param>
        /// <param name="dstType">変換後の型を指定します。</param>
        /// <param name="converter">変換の状態です。Converterから渡されます。</param>
        /// <returns>変換後のオブジェクトを返します。</returns>
        private object XmlSoundSetItemFolderToSoundSetItemPack(object src, Type dstType, Converter converter)
        {
            Assertion.Argument.True(src is XmlSoundSetItemFolder);
            Assertion.Argument.True(dstType == typeof(SoundSetItemPack));

            XmlSoundSetItemFolder xmlSrc = src as XmlSoundSetItemFolder;
            SoundSetItemPack dest = null;
            Type destType = null;

            switch (xmlSrc.Name)
            {
                case StreamSoundPack.ComponentName:
                    dest = new StreamSoundPack();
                    destType = typeof(StreamSoundBase);
                    break;

                case WaveSoundSetPack.ComponentName:
                    dest = new WaveSoundSetPack();
                    destType = typeof(WaveSoundSetBase);
                    break;

                case SequenceSoundSetPack.ComponentName:
                    dest = new SequenceSoundSetPack();
                    destType = typeof(SequenceSoundSetBase);
                    break;

                case SequenceSoundPack.ComponentName:
                    dest = new SequenceSoundPack();
                    destType = typeof(SequenceSoundBase);
                    break;

                case SoundSetBankPack.ComponentName:
                    dest = new SoundSetBankPack();
                    destType = typeof(SoundSetBankBase);
                    break;

                case WaveArchivePack.ComponentName:
                    dest = new WaveArchivePack();
                    destType = typeof(WaveArchiveBase);
                    break;

                case PlayerPack.ComponentName:
                    dest = new PlayerPack();
                    destType = typeof(PlayerBase);
                    break;

                case GroupPack.ComponentName:
                    dest = new GroupPack();
                    destType = typeof(GroupBase);
                    break;

                default:
                    dest = new SoundSetItemPack(xmlSrc.Name);
                    break;
            }

            TranslateParameters(xmlSrc, dest, converter);
            TranslateChildren(xmlSrc, dest, destType, converter);

            return dest;
        }
    }
}
