﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NintendoWare.SoundFoundation.Core
{
    /// <summary>
    /// パラメータイベントを処理するデリゲートです。
    /// </summary>
    /// <param name="sender">イベントの送信元を指定します。</param>
    /// <param name="e">イベントパラメータを指定します。</param>
    public delegate void NameChangedEventHandler(object sender, NameChangedEventArgs e);

    public class NameChangedEventArgs
    {
        private string _OldName = String.Empty;
        private string _NewName = String.Empty;

        ///--------------------------------
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public NameChangedEventArgs(string oldName, string newName)
        {
            _OldName = oldName;
            _NewName = newName;
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public string OldName
        {
            get { return _OldName; }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public string NewName
        {
            get { return _NewName; }
        }
    }
}
