﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Core
{
    /// <summary>
    /// オブジェクトのインスタンスを生成します。
    /// </summary>
    /// <typeparam name="TParam">パラメータの型を指定します。</typeparam>
    /// <typeparam name="TValue">生成するオブジェクトの型を指定します。</typeparam>
    public interface IObjectFactory<TParam, TValue>
    {
        /// <summary>
        /// 指定されたパラメータからオブジェクトのインスタンスを作成します。
        /// </summary>
        /// <param name="key">パラメータを指定します。</param>
        /// <returns>生成したオブジェクトのインスタンスを返します。</returns>
        TValue Create(TParam param);
    }
}
