﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Core.Wave
{
    using System;
    using System.Collections.Generic;
    using System.Runtime.InteropServices;

    public static class WaveDeviceManager
    {
        public static WaveOutDevice[] WaveOutDevices
        {
            get
            {
                List<WaveOutDevice> devices = new List<WaveOutDevice>();

                for (uint deviceID = 0; deviceID < Win32.Winmm.WaveOutGetNumDevs(); deviceID++)
                {
                    Win32.WAVEOUTCAPS caps = new Win32.WAVEOUTCAPS();
                    Win32.Winmm.WaveOutGetDevCaps(deviceID, out caps, (uint)Marshal.SizeOf(caps));

                    devices.Add(new WaveOutDevice(caps.strPname));
                }

                return devices.ToArray();
            }
        }

        public static uint GetDeviceID(string deviceName)
        {
            if (null == deviceName) { throw new ArgumentNullException("deviceName"); }

            for (uint deviceID = 0; deviceID < Win32.Winmm.WaveOutGetNumDevs(); deviceID++)
            {
                Win32.WAVEOUTCAPS caps = new Win32.WAVEOUTCAPS();
                Win32.Winmm.WaveOutGetDevCaps(deviceID, out caps, (uint)Marshal.SizeOf(caps));

                if (caps.strPname == deviceName) { return deviceID; }
            }

            return uint.MaxValue;
        }
    }
}
