﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Reflection;

namespace NintendoWare.SoundFoundation.Core.Reflection
{
    /// <summary>
    /// Assembly の拡張機能を提供します。
    /// </summary>
    public static class AssemblyEx
    {
        /// <summary>
        /// アセンブリに含まれるタイトルを取得します。
        /// </summary>
        public static string GetTitle(this Assembly assembly)
        {
            AssemblyTitleAttribute attr = GetAttibute<AssemblyTitleAttribute>(assembly);
            return (null == attr) ? string.Empty : attr.Title;
        }

        /// <summary>
        /// アセンブリに含まれる説明を取得します。
        /// </summary>
        public static string GetDescription(this Assembly assembly)
        {
            AssemblyDescriptionAttribute attr = GetAttibute<AssemblyDescriptionAttribute>(assembly);
            return (null == attr) ? string.Empty : attr.Description;
        }

        /// <summary>
        /// アセンブリに含まれるビルド構成を取得します。
        /// </summary>
        public static string GetConfiguration(this Assembly assembly)
        {
            AssemblyConfigurationAttribute attr = GetAttibute<AssemblyConfigurationAttribute>(assembly);
            return (null == attr) ? string.Empty : attr.Configuration;
        }

        /// <summary>
        /// アセンブリに含まれる会社名を取得します。
        /// </summary>
        public static string GetCompany(this Assembly assembly)
        {
            AssemblyCompanyAttribute attr = GetAttibute<AssemblyCompanyAttribute>(assembly);
            return (null == attr) ? string.Empty : attr.Company;
        }

        /// <summary>
        /// アセンブリに含まれる製品名を取得します。
        /// </summary>
        public static string GetProduct(this Assembly assembly)
        {
            AssemblyProductAttribute attr = GetAttibute<AssemblyProductAttribute>(assembly);
            return (null == attr) ? string.Empty : attr.Product;
        }

        /// <summary>
        /// アセンブリに含まれる著作権を取得します。
        /// </summary>
        public static string GetCopyright(this Assembly assembly)
        {
            AssemblyCopyrightAttribute attr = GetAttibute<AssemblyCopyrightAttribute>(assembly);
            return (null == attr) ? string.Empty : attr.Copyright;
        }

        /// <summary>
        /// アセンブリに含まれる商標を取得します。
        /// </summary>
        public static string GetTrademark(this Assembly assembly)
        {
            AssemblyTrademarkAttribute attr = GetAttibute<AssemblyTrademarkAttribute>(assembly);
            return (null == attr) ? string.Empty : attr.Trademark;
        }

        /// <summary>
        /// アセンブリがサポートしているカルチャを取得します。
        /// </summary>
        public static string GetCulture(this Assembly assembly)
        {
            AssemblyCultureAttribute attr = GetAttibute<AssemblyCultureAttribute>(assembly);
            return (null == attr) ? string.Empty : attr.Culture;
        }

        private static TAttr GetAttibute<TAttr>(Assembly assembly)
            where TAttr : Attribute
        {
            if (null == assembly) { throw new ArgumentNullException("assembly"); }
            return Attribute.GetCustomAttribute(assembly, typeof(TAttr)) as TAttr;
        }
    }
}

