﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Core.Parameters
{
    using System;
    using ToolDevelopmentKit;

    /// <summary>
    /// パラメータイベントを処理するデリゲートです。
    /// </summary>
    /// <param name="sender">イベントの送信元を指定します。</param>
    /// <param name="e">イベントパラメータを指定します。</param>
    public delegate void ParameterEventHandler(object sender, ParameterEventArgs e);

    /// <summary>
    /// パラメータイベントのパラメータを格納します。
    /// </summary>
    public class ParameterEventArgs : EventArgs
    {
        private string key;
        private IParameterValue parameterValue;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="key">対象パラメータのキーを指定します。</param>
        /// <param name="target">対象パラメータ値を指定します。</param>
        public ParameterEventArgs(string key, IParameterValue parameterValue)
        {
            Ensure.Argument.NotNull(key);
            Ensure.Argument.NotNull(parameterValue);

            this.key = key;
            this.parameterValue = parameterValue;
        }

        /// <summary>
        /// 対象パラメータのキーを取得します。
        /// </summary>
        public string Key
        {
            get { return this.key; }
        }

        /// <summary>
        /// 対象パラメータ値を取得します。
        /// </summary>
        public IParameterValue ParameterValue
        {
            get { return this.parameterValue; }
        }
    }
}
