﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;

namespace NintendoWare.SoundFoundation.Core.Parameters
{
    /// <summary>
    /// パラメータの値を格納します。
    /// </summary>
    public interface IParameterValue : IConstParameterValue
    {
        /// <summary>
        /// パラメータの値が変更されると発生します。
        /// </summary>
        event ParameterEventHandler ValueChanged;

        /// <summary>
        /// パラメータの値を取得または設定します。
        /// </summary>
        new object Value { get; set; }

        /// <summary>
        /// テキストからパラメータの値を設定します。
        /// </summary>
        /// <param name="text">テキストを指定します。</param>
        void Parse(string text);

        /// <summary>
        /// テキストからパラメータの値を設定します。
        /// </summary>
        /// <param name="text">テキストを指定します。</param>
        object ParseValue(string text);

        /// <summary>
        /// パラメータの値を検証します。
        /// </summary>
        /// <returns>検証結果を返します。</returns>
        ValidationResult Validate();

        /// <summary>
        /// 指定した値を検証します。
        /// </summary>
        /// <param name="value">検証する値を指定します。</param>
        /// <returns>検証結果を返します。</returns>
        ValidationResult ValidateValue(object value);
    }
}
