﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Collections.Generic;

namespace NintendoWare.SoundFoundation.Core.Collections
{
    public interface IReadOnlyEventRoutableCollection : IReadOnlyCollection<IEventRoutable>
    {
        /// <summary>
        /// 指定アイテムがコレクションに含まれているかどうかを調べます。
        /// </summary>
        /// <param name="item">アイテム。</param>
        /// <returns>含まれている場合は true、含まれていない場合は false。</returns>
        bool Contains(IEventRoutable item);
    }
}
