﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion
{
    public class SoundProjectConvertSettings : SoundProjectConvertBaseSettings
    {
        /// <summary>
        /// コンストラクタ。
        /// </summary>
        /// <param name="platform">対象プラットフォーム。</param>
        /// <param name="targets">出力のインストール先。</param>
        /// <param name="reconvertFilter">再コンバータフィルタ。</param>
        public SoundProjectConvertSettings(
            string platform,
            string installDirectoryPath,
            SoundProjectReconvertFilter reconvertFilter)
            : base(platform, reconvertFilter)
        {
            this.InstallDirectoryPath = installDirectoryPath ?? string.Empty;
        }

        /// <summary>
        /// 出力のインストール先を取得します。
        /// </summary>
        public string InstallDirectoryPath { get; private set; }

        /// <summary>
        /// 通常コンバート用の設定を生成します。
        /// </summary>
        /// <param name="platform">対象プラットフォーム。</param>
        public static SoundProjectConvertSettings CreateForConvert(string platform)
        {
            return CreateForConvert(platform, string.Empty);
        }

        /// <summary>
        /// 通常コンバート用の設定を生成します。
        /// </summary>
        /// <param name="platform">対象プラットフォーム。</param>
        /// <param name="installDirectoryPath">出力のインストール先。</param>
        public static SoundProjectConvertSettings CreateForConvert(
            string platform,
            string installDirectoryPath)
        {
            return new SoundProjectConvertSettings(
                platform,
                installDirectoryPath,
                SoundProjectReconvertFilter.None);
        }

        /// <summary>
        /// 再コンバート用の設定を生成します。
        /// </summary>
        /// <param name="platform">対象プラットフォーム。</param>
        public static SoundProjectConvertSettings CreateForReconvert(string platform)
        {
            return CreateForReconvert(
                platform,
                string.Empty,
                SoundProjectReconvertFilter.All);
        }

        /// <summary>
        /// 再コンバート用の設定を生成します。
        /// </summary>
        /// <param name="platform">対象プラットフォーム。</param>
        /// <param name="installDirectoryPath">出力のインストール先。</param>
        public static SoundProjectConvertSettings CreateForReconvert(
            string platform,
            string installDirectoryPath)
        {
            return CreateForReconvert(
                platform,
                installDirectoryPath,
                SoundProjectReconvertFilter.All);
        }

        /// <summary>
        /// 再コンバート用の設定を生成します。
        /// </summary>
        /// <param name="platform">対象プラットフォーム。</param>
        /// <param name="installDirectoryPath">出力のインストール先。</param>
        /// <param name="filter">再コンバートフィルタ。</param>
        public static SoundProjectConvertSettings CreateForReconvert(
            string platform,
            string installDirectoryPath,
            SoundProjectReconvertFilter filter)
        {
            return new SoundProjectConvertSettings(
                platform,
                installDirectoryPath,
                filter);
        }
    }
}
